package edu.cmu.cs.cs214.streamio;

import java.io.BufferedReader;
import java.io.InputStreamReader;
import java.rmi.RMISecurityManager;
import java.rmi.registry.LocateRegistry;
import java.rmi.registry.Registry;
import java.util.Scanner;

public class ComputeClient {

	/**
	 * @param args
	 */
	public static void main(String[] args) {
		if (args.length < 1) {
			System.err.println("usage: java cs214.sockets.ComputeClient host");
			System.exit(-1);
		}
		
		// allows the client to download a stub from the server if necessary
		if (System.getSecurityManager() == null) {
			System.setSecurityManager (new RMISecurityManager() {
			    public void checkConnect (String host, int port) {}
			    public void checkConnect (String host, int port, Object context) {}
			});
        }
		
		try {
            Registry registry = LocateRegistry.getRegistry(args[0]);
            Compute comp = (Compute) registry.lookup(ComputeServer.NAME);
    		Scanner scanner = new Scanner(System.in);

            while (true) {
            	String command = scanner.next();
            	if (command.equals("set")) {
            		int val = scanner.nextInt();
            		comp.set(val);
            		System.out.println("ok");
            	} else if (command.equals("add")) {
            		int val = scanner.nextInt();
            		val = comp.execute(new AddOp(val));
            		System.out.println("current total is " + val);
            	} else if (command.equals("exit")) {
            		System.out.println(comp.done());
            		System.exit(0);
            	} else {
            		System.err.println("I don't know how to " + command);
            	}
            }
        } catch (Exception e) {
            e.printStackTrace();
        }
	}

}
